#!/bin/bash

echo "Called $(basename $0) with arguments: ${@}" 1>&2

threads=0
options=$(getopt -o '' -l threads: -- "$@")
eval set -- "$options"

while true
do
case "$1" in
--threads)
	shift
	if [ 1 -le ${1} ]
	then
		threads=${1}
	fi
	;;
--)
	shift
	break
	;;
esac
shift
done <<< "$(echo)"

if [ 1 -gt ${threads} ]
then
	threads=`getconf _NPROCESSORS_ONLN`
fi

bowtie2-build --threads ${threads} ${RHAPSODY_HOME}/control_files/phix_genome.fasta phix 1> /dev/null 2>&1
bowtie2 -x phix --threads ${threads} -U $@ 1> /dev/null 2> phix_contamination.txt
cat phix_contamination.txt
