library(logger)

args <- commandArgs(trailingOnly = FALSE)

file.arg.name <- "--file="
script.name <- sub(file.arg.name, "", args[grep(file.arg.name, args)])
script.name <- basename(file.path(script.name))

node_name <- tools::file_path_sans_ext(script.name)
log_file_name <- paste0("mist_", tolower(node_name), ".log")
log_appender(appender_tee(log_file_name))

# Set the log level
log_threshold(TRACE)

# set the log foramt
op <- options(digits.secs=3)
logger <- layout_glue_generator(format = '{level} {format(time, \"%Y-%m-%d %H:%M:%S\")} - {node_name} - {user} - {msg}')
log_layout(logger)