# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "13.3.0",
                "commands": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/_build_env/bin/x86_64-conda-linux-gnu-cc",
                "args": r"-march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /condaEnv/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/work=/usr/local/src/conda/scipy-split-1.15.0, -fdebug-prefix-map=/condaEnv=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /condaEnv/include",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,--disable-new-dtags, -Wl,--gc-sections, -Wl,--allow-shlib-undefined, -Wl,-rpath,/condaEnv/lib, -Wl,-rpath-link,/condaEnv/lib, -L/condaEnv/lib, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /condaEnv/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/work=/usr/local/src/conda/scipy-split-1.15.0, -fdebug-prefix-map=/condaEnv=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /condaEnv/include",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.0.11",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "13.3.0",
                "commands": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/_build_env/bin/x86_64-conda-linux-gnu-c++",
                "args": r"-fvisibility-inlines-hidden, -fmessage-length=0, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /condaEnv/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/work=/usr/local/src/conda/scipy-split-1.15.0, -fdebug-prefix-map=/condaEnv=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /condaEnv/include",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,--disable-new-dtags, -Wl,--gc-sections, -Wl,--allow-shlib-undefined, -Wl,-rpath,/condaEnv/lib, -Wl,-rpath-link,/condaEnv/lib, -L/condaEnv/lib, -fvisibility-inlines-hidden, -fmessage-length=0, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /condaEnv/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/work=/usr/local/src/conda/scipy-split-1.15.0, -fdebug-prefix-map=/condaEnv=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /condaEnv/include",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "13.3.0",
                "commands": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/_build_env/bin/x86_64-conda-linux-gnu-gfortran",
                "args": r"-march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /condaEnv/include, -I/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/_build_env/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/work=/usr/local/src/conda/scipy-split-1.15.0, -fdebug-prefix-map=/condaEnv=/usr/local/src/conda-prefix",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,--disable-new-dtags, -Wl,--gc-sections, -Wl,--allow-shlib-undefined, -Wl,-rpath,/condaEnv/lib, -Wl,-rpath-link,/condaEnv/lib, -L/condaEnv/lib, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /condaEnv/include, -I/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/_build_env/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1736351738557/work=/usr/local/src/conda/scipy-split-1.15.0, -fdebug-prefix-map=/condaEnv=/usr/local/src/conda-prefix",
            },
            "pythran": {
                "version": r"0.17.0",
                "include directory": r"../../_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib/python3.11/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"linux",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"linux",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/condaEnv/include",
                "lib directory": r"/condaEnv/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/condaEnv/lib/pkgconfig",
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/condaEnv/include",
                "lib directory": r"/condaEnv/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/condaEnv/lib/pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "2.13.6",
                "detection method": "pkgconfig",
                "include directory": r"/condaEnv/include",
            },
        },
        "Python Information": {
            "path": r"/condaEnv/bin/python",
            "version": "3.11",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
