cwlVersion: v1.2
class: ExpressionTool
requirements:
- class: InlineJavascriptRequirement
inputs:
  _VDJ_Version:
    type: Any?

outputs:
  VDJ_Version:
    type: string?
  VDJ_VGene_Evalue:
    type: float?
  VDJ_JGene_Evalue:
    type: float?

expression: |-
  ${
    var vdjVersion = null;
    if (!inputs._VDJ_Version) {
      vdjVersion = null;}
    else {
      var _VDJ_Version = inputs._VDJ_Version.toLowerCase();
      if (_VDJ_Version === "human" || _VDJ_Version === "hs" || _VDJ_Version === "human vdj - bcr and tcr") {
        vdjVersion = "human";
      } else if (_VDJ_Version === "humanbcr" || _VDJ_Version === "human vdj - bcr only") {
        vdjVersion = "humanBCR";
      } else if (_VDJ_Version === "humantcr" || _VDJ_Version === "human vdj - tcr only") {
        vdjVersion = "humanTCR";
      } else if (_VDJ_Version === "mouse" || _VDJ_Version === "mm" || _VDJ_Version === "mouse vdj - bcr and tcr") {
        vdjVersion = "mouse";
      } else if (_VDJ_Version === "mousebcr" || _VDJ_Version === "mouse vdj - bcr only") {
        vdjVersion = "mouseBCR";
      } else if (_VDJ_Version === "mousetcr" || _VDJ_Version === "mouse vdj - tcr only") {
        vdjVersion = "mouseTCR";
      } else {
        vdjVersion = inputs._VDJ_Version;
      }
    }

    return ({
    VDJ_Version: vdjVersion,
    })
  }
