# VDJ_num_splits:  Determine the number of splits of data for scattering during the Assemble step
  # SBG: 
    # We need to decide on num_splits and num_cores - based on the instance types that we provision for both TCR and BCR assembly
    # Aiming to have each job run concurrently on the instances, with no sequential jobs
    # If the number of reads is large, aim to use 2 instances, with double the number of splits 
    #  - this is controlled by setting the num_cores to double
    # Because of past failures in this node, we are using RAM limits to put a specific number of jobs on selected instances
    #  ("ram_per_split = 3200" and see VDJ_Assemble_and_Annotate_Contigs.cwl)
    # Each job takes ~1.3 cpu cores
  # Local:
    # If Maximum_Threads is set, use that, but reduce the number of splits by 0.7, so as to hopefully not exceed the max
    # Otherwise, make a fixed number of splits and let the CWL-runner provision based on available cores and ram.  May run
    # concurrently or some sequenctial, based on avaiable resources
    # For local runs, num_cores parameter is not used, so it is just set to the same value as num_splits

class: Workflow
cwlVersion: v1.2
inputs:
  Valid_Reads_Fastq:
    type: File?
  num_valid_reads:
    type: long
  vdj_type:
    type: string
  Maximum_Threads:
    type: int?
outputs:
  RSEC_Reads_Fastq:
    outputSource: VDJ_RSEC_Reads/RSEC_Reads_Fastq
    type: File[]
  num_splits:
    outputSource: VDJ_num_splits/num_splits
    type: int?
  num_cores:
    outputSource: VDJ_num_splits/num_cores
    type: int?
requirements:
  SubworkflowFeatureRequirement: {}
  InlineJavascriptRequirement: {}
  EnvVarRequirement:
    envDef:
      CORES_ALLOCATED_PER_CWL_PROCESS: "8"
steps:
  VDJ_num_splits:
    id: VDJ_num_splits
    in:
      num_valid_reads: num_valid_reads
      vdj_type: vdj_type
      Maximum_Threads: Maximum_Threads
    out:
      - num_splits
      - num_cores
    run:
      id: determine_num_splits
      cwlVersion: v1.2
      class: ExpressionTool
      inputs:
        num_valid_reads:
          type: long?
        vdj_type:
          type: string
        Maximum_Threads:
          type: int?
      outputs:
        num_splits:
          type: int?
        num_cores:
          type: int?
      expression: |-
        ${
          var num_splits = 64;
          var max_threads = parseInt(inputs.Maximum_Threads);
          if (!isNaN(max_threads)) {
            num_splits = parseInt(Math.max(max_threads, 8) * 0.7);
          }
          return ({"num_splits": num_splits, "num_cores": num_splits});
        }

  VDJ_Trim_Reads:
    id: VDJ_Trim_Reads
    hints:
      - class: ResourceRequirement
        coresMin: 8
    run: VDJ_Trim_Reads.cwl
    in:
      Valid_Reads_Fastq: Valid_Reads_Fastq
    out:
    - Valid_Reads
    - Trim_Report

  VDJ_RSEC_Reads:
    id: VDJ_RSEC_Reads
    requirements:
    - class: ResourceRequirement
      coresMin: 8
    run: VDJ_RSEC_Reads.cwl
    in:
      Valid_Reads: VDJ_Trim_Reads/Valid_Reads
      num_splits: VDJ_num_splits/num_splits
      num_valid_reads: num_valid_reads
    out:
    - RSEC_Reads_Fastq
