doc: >
   VDJ_GatherCalls collect the outputs from the multi-processed VDJ step into one file.
cwlVersion: v1.2
class: Workflow
requirements:
- class: InlineJavascriptRequirement
inputs:
  theCalls:
    type: File[]?
  VDJ_Version:
    type: string?
outputs:
  gatheredCalls:
    type: File?
    outputSource: VDJ_GatherCalls/gatheredCalls
steps:
  VDJ_GatherCalls:
    in:
      theCalls: theCalls
    out:
    - gatheredCalls
    run:
      id: gather_IgBlast
      cwlVersion: v1.2
      class: CommandLineTool
      hints:
        DockerRequirement:
          dockerPull: mist:dev_20251028_183627_5d0e14dd
      requirements:
        InlineJavascriptRequirement: {}
        ShellCommandRequirement: {}
      inputs:
        theCalls:
          type: File[]?
      arguments:
        - shellQuote: false
          valueFrom: |-
            ${
              if (!inputs.theCalls[0] ) {
                return ("echo \"No outputs from IgBlast detected in VDJ_GatherCalls\"")
              }
              var inputFiles = ""
              if (!inputs.theCalls[0].path.split("_PruneIgBlast")[1]){
                inputFiles = "zcat"
                for (var i = 0; i < inputs.theCalls.length; i++) {
                  inputFiles += " " + inputs.theCalls[i].path
                }
                inputFiles += " | "
              } else {
                inputFiles = "zcat " + inputs.theCalls[0].path.split("VDJ")[0] + "*" + inputs.theCalls[0].path.split("_PruneIgBlast")[1].split("_Number_")[0] + "_Number_*.csv.gz | "
              }
              var outputFileName = "\"gzip > " + inputs.theCalls[0].nameroot.split("_Number_")[0] + "_constant_region_called_pruned.csv.gz" + "\""
              var awkCommand =  "awk \'NR==1{F=$1;print | " + outputFileName + " } $1!=F { print | " + outputFileName + " }\' "
              var outputCommand = inputFiles + awkCommand
              return (outputCommand)
            }
      outputs:
        gatheredCalls:
          type: File?
          outputBinding:
            glob: '*_constant_region_called_pruned.csv.gz'
            outputEval: |-
              ${
                if (self.size == 0) {
                  throw("No outputs from IgBlast detected in VDJ_GatherCalls!");
                } else {
                  return(self);
                }
              }
