class: CommandLineTool
cwlVersion: v1.2

hints:
  - class: 'ResourceRequirement'
    ramMin: 32000
  - class: 'DockerRequirement'
    dockerPull: mist:dev_20251028_183627_5d0e14dd

requirements:
  InlineJavascriptRequirement: {}

baseCommand:
  - mist_vdj_compile_results.py

inputs:
  cellTypeMapping:
    type: File[]?
    inputBinding:
      position: 0
      itemSeparator: ','
      prefix: "--cell-type-mapping-fp"
  VDJ_Version:
    type: string?
    inputBinding:
      prefix: "--vdj-version"
      position: 2
  putativeCells:
    type: File?
    inputBinding:
      prefix: "--putative-cells-json-fp"
      position: 3
  chainsToIgnore:
    type: string[]?
    inputBinding:
      position: 4
      prefix: "--ignore"
      itemSeparator: ","
  igCalls:
    type: File?
    inputBinding:
      position: 5
  tcrCalls:
    type: File?
    inputBinding:
      position: 6
  evalueVgene:
    type: float?
    inputBinding:
      position: 7
      prefix: "--e-value-for-v"
  evalueJgene:
    type: float?
    inputBinding:
      position: 8
      prefix: "--e-value-for-j"
  metadata:
    type: File
    inputBinding:
      position: 9
      prefix: "--metadata-fp"
  Seq_Metrics:
    type: File
    inputBinding:
      prefix: "--seq-metrics"
      position: 10

outputs:
  vdjCellsDatatable:
    doc: VDJ data per cell, with distribution based error correction
    type: File?
    outputBinding:
      glob: "*_VDJ_perCell.csv"
  vdjCellsDatatableUncorrected:
    doc: VDJ data per cell, including non-putative cells, no error correction applied
    type: File?
    outputBinding:
      glob: "*_VDJ_perCell_uncorrected.csv.gz"
  vdjDominantContigsAIRR:
    doc: AIRR compatible output that only reports the Dominant contigs, counts are DBEC corrected
    type: File?
    outputBinding:
      glob: "*_VDJ_Dominant_Contigs_AIRR.tsv"
  vdjUnfilteredContigsAIRR:
    type: File?
    doc: AIRR compatible output that reports all the congits, counts are not DBEC corrected 
    outputBinding:
      glob: "*_VDJ_Unfiltered_Contigs_AIRR.tsv.gz"
  vdjMetricsCsv:
    type: File?
    outputBinding:
      glob: "*_VDJ_metrics.csv"
  vdjDbecFilterImages:
    type: File?
    outputBinding:
      glob: "*_VDJ_DBEC_images.tar.gz"
  vdjMetricsTar:
    type: File?
    outputBinding:
      glob: "vdj-metrics-files.tar.gz"
  Cell_Order:
    type: File?
    outputBinding:
      glob: "cell_order.json"