class: Workflow
cwlVersion: v1.2
inputs:
  Valid_Reads_Fastq_TCR:
    type: File?
  Num_Valid_Reads_TCR:
    type: long
  VDJ_Version:
    type: string?
  Maximum_Threads:
    type: int?
outputs:
  gatheredCalls:
    type: File?
    outputSource: VDJ_GatherTCRCalls/gatheredCalls
requirements:
- class: SubworkflowFeatureRequirement
- class: InlineJavascriptRequirement
- class: StepInputExpressionRequirement

steps:
  VDJ_Preprocess_Reads_TCR:
    run: VDJ_Preprocess_Reads.cwl
    in:
      Valid_Reads_Fastq: Valid_Reads_Fastq_TCR
      num_valid_reads: Num_Valid_Reads_TCR
      vdj_type: {valueFrom: "TCR"}
      Maximum_Threads: Maximum_Threads
    out:
    - RSEC_Reads_Fastq
    - num_splits
    - num_cores
  VDJ_Assemble_and_Annotate_Contigs_TCR:
    run: VDJ_Assemble_and_Annotate_Contigs_TCR.cwl
    in:
      RSEC_Reads_Fastq: VDJ_Preprocess_Reads_TCR/RSEC_Reads_Fastq
      num_cores: VDJ_Preprocess_Reads_TCR/num_cores
      VDJ_Version: VDJ_Version
    out:
    - tcrCalls
  VDJ_GatherTCRCalls:
    run: VDJ_GatherCalls.cwl
    in:
      theCalls: VDJ_Assemble_and_Annotate_Contigs_TCR/tcrCalls
      VDJ_Version: VDJ_Version
    out:
    - gatheredCalls
