class: Workflow
cwlVersion: v1.2
inputs:
  Valid_Reads_Fastq_IG:
    type: File?
  Num_Valid_Reads_IG:
    type: long
  VDJ_Version:
    type: string?
  Maximum_Threads:
    type: int?
outputs:
  gatheredCalls:
    type: File?
    outputSource: VDJ_GatherIGCalls/gatheredCalls
requirements:
- class: SubworkflowFeatureRequirement
- class: InlineJavascriptRequirement
- class: StepInputExpressionRequirement

steps:
  VDJ_Preprocess_Reads_IG:
    run: VDJ_Preprocess_Reads.cwl
    in:
      Valid_Reads_Fastq: Valid_Reads_Fastq_IG
      num_valid_reads: Num_Valid_Reads_IG
      vdj_type: {valueFrom: "BCR"}
      Maximum_Threads: Maximum_Threads
    out:
    - RSEC_Reads_Fastq
    - num_splits
    - num_cores
  VDJ_Assemble_and_Annotate_Contigs_IG:
    run: VDJ_Assemble_and_Annotate_Contigs_IG.cwl
    in:
      RSEC_Reads_Fastq: VDJ_Preprocess_Reads_IG/RSEC_Reads_Fastq
      num_cores: VDJ_Preprocess_Reads_IG/num_cores
      VDJ_Version: VDJ_Version
    out:
    - igCalls
  VDJ_GatherIGCalls:
    run: VDJ_GatherCalls.cwl
    in:
      theCalls: VDJ_Assemble_and_Annotate_Contigs_IG/igCalls
      VDJ_Version: VDJ_Version
    out:
    - gatheredCalls
