cwlVersion: v1.2
requirements:
  InlineJavascriptRequirement: {}
  ShellCommandRequirement: {}
doc: >
  CheckFastqs does several quality control routines including: ensuring that read
  pair file names are formatted correctly and contain a read pair mate; 
  QualCLAlign stage of the Rain pipeline overlaps read pairs and then performs
  a series of filters and mappings to reduce valid reads into a single
  FastQ file to be fed into the aligner. The R2 reads are annotated with
  cell index and UMI information derived from the R1 read.
hints:
- class: DockerRequirement
  dockerPull: mist:dev_20251028_183627_5d0e14dd
- class: ResourceRequirement
  coresMin:
      ${
        if(inputs.Threads){
          return inputs.Threads;
        }
        else{
          return 8;
        }
       }
  ramMin: 48000
class: CommandLineTool
baseCommand:
- mist_run_qualclalign.py
inputs:
  Reads:
    type: File[]
    inputBinding:
      prefix: "--reads"
      itemSeparator: ','
  Predefined_ATAC_Peaks:
    type: File?
    inputBinding:
      prefix: "--predefined-peaks"
    secondaryFiles: .tbi
  Threads:
    type: int?
    inputBinding:
      prefix: "--threads"
  Write_Filtered_Reads:
    type: boolean?
    inputBinding:
      prefix: "--write-filtered-read-pairs"
  BGZF_Threads:
    type: int?
    inputBinding:
      prefix: "--bgzf-threads"
  Reader_Annotation_Threads:
    inputBinding:
      prefix: "--reader-annotation-threads"
    type: string?
  Alignment_Compression_threads:
    inputBinding:
      prefix: "--alignment-compression-threads"
    type: string?
  Assay:
    type: string?
    inputBinding:
      prefix: "--assay"
  Run_Base_Name:
    type: string?
    inputBinding:
      prefix: "--run-name"
  VDJ_Version:
    type: string?
    inputBinding:
      prefix: "--vdj-version"
  Index:
    inputBinding:
      prefix: "--index"
    type: Directory
  Extra_Seqs:
    inputBinding:
      prefix: "--extra-seqs"
    type: File?
  STAR_Params:
    inputBinding:
      prefix: "--star-params"
      shellQuote: true
    type: string?
  bwa_mem2_Params:
    inputBinding:
      prefix: "--bwa-mem2-params"
      shellQuote: true
    type: string?
  Long_Reads:
    inputBinding:
      prefix: "--use-star-long"
    type: string?
  Generate_Bam:
    type: boolean?
    inputBinding:
      prefix: "--split-atac-bam"
outputs:
  Bead_Version:
    type:
      type: array
      items:
        type: record
        fields:
        - name: Library
          type: string
        - name: bead_version
          type: string
    outputBinding:
      glob: bead_version.json
      loadContents: true
      outputEval: |
        $(JSON.parse(self[0].contents).BeadVersion)
  Libraries:
    type: string[]
    outputBinding:
      glob: bead_version.json
      loadContents: true
      outputEval: |
        ${
          var obj = JSON.parse(self[0].contents);
          var libraries = [];
          var beadLibs = obj.BeadVersion
          for (var i in beadLibs){
            if (libraries.indexOf(beadLibs[i]["Library"]) == -1){ 
              libraries.push(beadLibs[i]["Library"]);
            }
          }
          libraries.sort();
          return libraries
        }
  ReadsList:
    type: string[]
    outputBinding:
      outputEval: |
        ${  
          var reads = []; 
          var files = inputs.Reads
          for (var i in files){
              reads.push(files[i]["basename"]);
          }
          reads.sort();
          return(reads)
        }
  Logs:
    outputBinding:
      glob: "*logs.tar.gz"
    type: File[]
  BAMFiles:
    outputBinding:
      glob: "*.bam"
    type: File[]
  Fragments:
    outputBinding:
      glob: "*_ATAC_Fragments.bed.gz"
    type: File?
    secondaryFiles: 
      - .tbi
  Fragments_Index:
    outputBinding:
      glob: "*_ATAC_Fragments.bed.gz.tbi"
    type: File?
  Transposase_Sites:
    outputBinding:
      glob: "*_ATAC_Transposase_Sites.bed.gz"
    type: File?
    secondaryFiles: 
      - .tbi
  Transposase_Sites_Index:
    outputBinding:
      glob: "*_ATAC_Transposase_Sites.bed.gz.tbi"
    type: File?
  Peaks:
    outputBinding:
      glob: "*_ATAC_Peaks.bed.gz"
    type: File?
    secondaryFiles: 
      - .tbi
  Peaks_Index:
    outputBinding:
      glob: "*_ATAC_Peaks.bed.gz.tbi"
    type: File?
  QualCLAlignMetrics:
    outputBinding:
      glob: "*ReadQualityMetrics.json"
    type: File
  UnifiedMetrics:
    outputBinding:
      glob: "*_ATAC_UnifiedMetrics.json"
    type: File?
  Fastq_read_pairs:
    outputBinding:
      glob: fastq_read_pairs.json
    type: File
  Failed_Reads_CSVs:
    outputBinding:
      glob: "*.failedReads.csv.gz"
    type: File[]?
  Reference_Genome_Size:
    type: string
    outputBinding:
      glob: genome_size.json
      loadContents: true
      outputEval:
        ${
          if (!self[0]) {
            return "0";
          }
          return JSON.parse(self[0].contents);
        }
  Reference_Genome_Contig_Lengths:
    outputBinding:
      glob: genome_contig_lengths.json
    type: File?
