#!/usr/bin/env cwl-runner
cwlVersion: v1.2
class: CommandLineTool
baseCommand: echo
requirements:
  - class: InlineJavascriptRequirement

# Defaults (when a value is not specified):
# Note: "Cell_Calling_Data" integers are defined in src/mist/lib/constants.py PutativeCellCall
#   Cell_Calling_ATAC_Algorithm: Basic
#   Cell_Calling_Bioproduct_Algorithm: Basic
#   Cell_Calling_Data:
#       - if (Reads_Present and Reads_ATAC_Present):
#           - if (Sample_Tags_Version == "nuclei_atac_only"):
#               - ATAC = 5
#           - else:
#               - mRNA_and_ATAC = 3
#       - elif (not Reads_Present and Reads_ATAC_Present):
#           - ATAC = 5
#       - else:
#           - mRNA = 0
#   Expected_Cell_Count: None/Null
#   Exact_Cell_Count: None/Null
inputs:
  _Cell_Calling_ATAC_Algorithm:
    type: Any?
  _Cell_Calling_Bioproduct_Algorithm:
    type: Any?
  _Cell_Calling_Data:
    type: Any?
  _Exact_Cell_Count:
    type: int?
  _Expected_Cell_Count:
    type: int?
  _Sample_Tags_Version:
    type: string?
  _Reads_ATAC_Present:
    type: boolean
  _Reads_Present:
    type: boolean
outputs:
  PutativeCellSettings:
    type: File
    outputBinding:
      glob: "putative_cell_settings.json"
  Cell_Calling_ATAC_Algorithm:
    type: Any?
    outputBinding:
      glob: putative_cell_settings.json
      loadContents: true
      outputEval:
        ${
          return JSON.parse(self[0].contents).Cell_Calling_ATAC_Algorithm;
        }
  Cell_Calling_Bioproduct_Algorithm:
    type: Any?
    outputBinding:
      glob: putative_cell_settings.json
      loadContents: true
      outputEval:
        ${
          return JSON.parse(self[0].contents).Cell_Calling_Bioproduct_Algorithm;
        }
  Cell_Calling_Data:
    type: int
    outputBinding:
      glob: putative_cell_settings.json
      loadContents: true
      outputEval:
        ${
          return JSON.parse(self[0].contents).Cell_Calling_Data;
        }
  Exact_Cell_Count:
    type: int?
    outputBinding:
      glob: putative_cell_settings.json
      loadContents: true
      outputEval:
        ${
          return JSON.parse(self[0].contents).Exact_Cell_Count;
        }
  Expected_Cell_Count:
    type: int?
    outputBinding:
      glob: putative_cell_settings.json
      loadContents: true
      outputEval:
        ${
          return JSON.parse(self[0].contents).Expected_Cell_Count;
        }
stdout: putative_cell_settings.json
arguments:
  - prefix: ''
  - shellQuote: True
    valueFrom: |
      ${
        var settings = inputs;
        var errorMessage = "No error";

        var cellCallingATACAlg = null;
        // the default cell calling algorithm for ATAC is basic
        if (inputs._Reads_ATAC_Present) {
            cellCallingATACAlg = "Basic";
        }
        // the user can choose the ATAC cell calling algorithm
        if (inputs._Cell_Calling_ATAC_Algorithm) {
            cellCallingATACAlg = inputs._Cell_Calling_ATAC_Algorithm;
        }

        var cellCallingBioproductAlg = null;
        // the default cell calling algorithm for bioproducts is basic
        if (inputs._Reads_Present) {
            cellCallingBioproductAlg = "Basic";
        }
        // the user can choose the bioproducts cell calling algorithm
        if (inputs._Cell_Calling_Bioproduct_Algorithm) {
            cellCallingBioproductAlg = inputs._Cell_Calling_Bioproduct_Algorithm;
        }

        // the default cell calling data depends on the data that is provided
        // the overall default is mRNA data
        var cellCallingDataInt = 0;
        // if reads and ATAC reads are present
        if (inputs._Reads_Present && inputs._Reads_ATAC_Present) {
            // if the sample tag version is set to ATAC-only,
            // then the reads are SMK reads, default to ATAC cell calling
            if (inputs._Sample_Tags_Version && inputs._Sample_Tags_Version === "nuclei_atac_only") {
                cellCallingDataInt = 5;
            }
            // otherwise default to joint cell calling
            else {
                cellCallingDataInt = 3;
            }
        }
        // if no mRNA or AbSeq data is present, but ATAC data is, then default to ATAC
        else if (!inputs._Reads_Present && inputs._Reads_ATAC_Present) {
            cellCallingDataInt = 5;
        }

        // convert the Cell_Calling_Data from a string to an integer
        if (inputs._Cell_Calling_Data) {
          if (inputs._Cell_Calling_Data === "mRNA") {
            if (!inputs._Reads_Present) {
              errorMessage = 'The "Cell Calling Data" option "mRNA" was selected but no mRNA Reads were provided.';
            } else {
              cellCallingDataInt = 0;
            }
          }
          else if (inputs._Cell_Calling_Data === "AbSeq") {
            if (!inputs._Reads_Present) {
              errorMessage = 'The "Cell Calling Data" option "AbSeq" was selected but no AbSeq Reads were provided.';
            }
            cellCallingDataInt = 1;
          }
          else if (inputs._Cell_Calling_Data === "mRNA_and_AbSeq") {
            if (!inputs._Reads_Present) {
              errorMessage = 'The "Cell Calling Data" option "mRNA_and_AbSeq" was selected but no mRNA/AbSeq Reads were provided.';
            }
            cellCallingDataInt = 2;
          }
          else if (inputs._Cell_Calling_Data === "mRNA_and_ATAC") {
            if (!inputs._Reads_Present) {
              errorMessage = 'The "Cell Calling Data" option "mRNA_and_ATAC" was selected but no mRNA Reads were provided.';
            } else if (!inputs._Reads_ATAC_Present) {
              errorMessage = 'The "Cell Calling Data" option "mRNA_and_ATAC" was selected but no ATAC Reads were provided.';
            }
            cellCallingDataInt = 3;
          }
          else if (inputs._Cell_Calling_Data === "AbSeq_and_ATAC") {
            if (!inputs._Reads_Present) {
              errorMessage = 'The "Cell Calling Data" option "AbSeq_and_ATAC" was selected but no AbSeq Reads were provided.';
            } else if (!inputs._Reads_ATAC_Present) {
              errorMessage = 'The "Cell Calling Data" option "AbSeq_and_ATAC" was selected but no ATAC Reads were provided.';
            }
            cellCallingDataInt = 4;
          }
          else if (inputs._Cell_Calling_Data === "ATAC") {
            if (!inputs._Reads_ATAC_Present) {
              errorMessage = 'The "Cell Calling Data" option "ATAC" was selected but no ATAC Reads were provided.';
            }
            cellCallingDataInt = 5;
          }
          else if (inputs._Cell_Calling_Data === "VDJ") {
            if (!inputs._Reads_Present) {
              errorMessage = 'The "Cell Calling Data" option "VDJ" was selected but no mRNA Reads were provided.';
            }
            cellCallingDataInt = 6;
          }
          // if reads and ATAC reads are present
          if (inputs._Reads_Present && inputs._Reads_ATAC_Present) {
            // if the sample tag version is set to ATAC-only,
            // then the reads are probably SMK reads
            // create error if ATAC is not selected for cell calling
            if (inputs._Sample_Tags_Version && inputs._Sample_Tags_Version === "nuclei_atac_only" && inputs._Cell_Calling_Data != "ATAC") {
              errorMessage = 'Incompatible input parameters detected: the "Cell Calling Data" option "' + inputs._Cell_Calling_Data + '" and the "Sample Tag Version" option "Nuclei - ATAC-Only" are incompatible.';
            }
          }
        }
        // check the exact cell count
        if (inputs._Exact_Cell_Count) {
          if (inputs._Exact_Cell_Count < 1) {
            errorMessage = "Exact cell count must be an integer greater than 0, value received: " + inputs._Exact_Cell_Count;
          }
        }
        // check if there is an error
        if (errorMessage != "No error") {
          // If there is an error, force CWL to show it:
          //   - "Cell_Calling_Data" is a required output
          //   - setting it to null will cause a CWL error
          //   - the error message will be shown in the json
          cellCallingDataInt = null;
        }

        settings["Cell_Calling_ATAC_Algorithm"] = cellCallingATACAlg;
        settings["Cell_Calling_Bioproduct_Algorithm"] = cellCallingBioproductAlg;
        settings["Cell_Calling_Data"] = cellCallingDataInt;
        settings["Expected_Cell_Count"] = inputs._Expected_Cell_Count;
        settings["Exact_Cell_Count"] = inputs._Exact_Cell_Count;
        settings["Error"] = errorMessage;

        var settings_json = JSON.stringify(settings, null, 2);

        return settings_json;
        }
