cwlVersion: v1.2

class: CommandLineTool

requirements:
  InlineJavascriptRequirement: {}
  ShellCommandRequirement: {}

doc: >
  NameSettings sets the Run_Name variable that is used as a common prefix to name output files.
  If the user has specified a Run_Name, it is cleaned up or one is set based on the Bioproduct/ATAC fastq filenames.

hints:
- class: DockerRequirement
  dockerPull: mist:dev_20251028_183627_5d0e14dd

baseCommand: [python, -c]

inputs:
  _Run_Name:
    type: string?
    default: ''
  Bioproduct_Fastqs:
    type: string[]?
    default: []
  ATAC_Fastqs:
    type: string[]?
    default: []

arguments:
  - position: 2
    valueFrom: |
      import sys
      from mist.apps import CheckFastqs
      CheckFastqs.write_run_name_json(sys.argv[1], sys.argv[2], sys.argv[3])
    shellQuote: true
  - position: 3
    valueFrom: $(inputs._Run_Name)
    shellQuote: true
  - position: 4
    valueFrom: $(inputs.Bioproduct_Fastqs.join(","))
    shellQuote: true
  - position: 5
    valueFrom: $(inputs.ATAC_Fastqs.join(","))
    shellQuote: true

outputs:
  Run_Name:
    type: string?
    outputBinding:
      outputEval: $(inputs._Run_Name)
  Run_Base_Name:
   type: string
   outputBinding:
    glob: run_base_name.json
    loadContents: true
    outputEval: $(JSON.parse(self[0].contents)['Run_Base_Name'])


