cwlVersion: v1.2
class: ExpressionTool
requirements:
- class: InlineJavascriptRequirement
inputs:
  _Sample_Tag_Names:
    type: string[]?
  _Sample_Tags_Version:
    type: Any?
  Assay:
    type: string
    default: "Targeted"
outputs:
  Sample_Tag_Names:
    type: string[]?
  Sample_Tags_Version:
    type: string?
expression: |-
  ${
    var enumifiedSampleTagsVersion = null;
    if (inputs._Sample_Tags_Version) {
    var _Sample_Tags_Version = inputs._Sample_Tags_Version.toLowerCase();

    if (_Sample_Tags_Version.indexOf('human') >= 0 || _Sample_Tags_Version === 'hs')
    {
      enumifiedSampleTagsVersion = 'hs';
    }
    else if (_Sample_Tags_Version.indexOf('mouse') >= 0 || _Sample_Tags_Version === 'mm')
    {
      enumifiedSampleTagsVersion = 'mm';
    }
    else if (_Sample_Tags_Version.indexOf('flex') >= 0)
    {
      enumifiedSampleTagsVersion = 'flex';
    }
    else if (_Sample_Tags_Version.indexOf('nuclei') >= 0)
    {
      if (_Sample_Tags_Version.indexOf('atac') >= 0)
      {
        enumifiedSampleTagsVersion = 'nuclei_atac_only';
      }
      else
      {
        enumifiedSampleTagsVersion = 'nuclei_includes_mrna';
      }
    }
    else if (_Sample_Tags_Version === 'no multiplexing')
    {
      enumifiedSampleTagsVersion = null;
    }
    else
    {
      throw new Error("Cannot parse Sample Tag Version: " + inputs._Sample_Tags_Version);
    }
    }
    var newSampleTags = null;
    var warning = '';
    var malformedSampleTags = [];
    if (inputs._Sample_Tag_Names) {
      var listSampleTags = inputs._Sample_Tag_Names;
      var newSampleTags = [];

      // loop over the custom sample tags
      for (var i = 0; i < listSampleTags.length; i++) {
        var sampleTag = listSampleTags[i];
        var newSampleTagItems = [];

        // the custom sample tag must include a dash between the number and the name
        if (sampleTag.includes("-")) {
            var sampleTagItemsList = sampleTag.split("-");

            // loop over the items separated by a dash
            for (var j = 0; j < sampleTagItemsList.length; j++) {
                var sampleTagItem = sampleTagItemsList[j]

                // remove the leading and trailing spaces
                newSampleTagItems.push(sampleTagItem.trim());
            }
            // after removing all leading and trailing spaces from the items separated by a dash
            var newSampleTag = newSampleTagItems.join("-");

            // only alpha-numeric and + and - are allowed, replace everything else with underscore
            var finalSampleTag = newSampleTag.replace(/[^A-Za-z0-9-+]/g,"_");
            newSampleTags.push(finalSampleTag);
        } else {
            malformedSampleTags.push(sampleTag);
        }
      }
    }

    // add a warning about malformed sample tags
    if (malformedSampleTags.length > 0) {
        warning = "The following sample tag names do not contain the required dash symbol (-) and will be skipped: [" + malformedSampleTags.join(",") + "]";
    }

    return ({
    Sample_Tag_Names: newSampleTags,
    Sample_Tags_Version: enumifiedSampleTagsVersion,
    Warning: warning
    });
  }
