# Defaults (when a value is not specified):
#   Exclude_Intronic_Reads: false
cwlVersion: v1.2
class: ExpressionTool
requirements:
- class: InlineJavascriptRequirement
inputs:
  _Exclude_Intronic_Reads:
    type: boolean?
  _Long_Reads:
    type: boolean?
  _Custom_STAR_Params:
    type: string?
  _Custom_bwa_mem2_Params:
    type: string?
outputs:
  Exclude_Intronic_Reads:
    type: boolean?
  Long_Reads:
    type: string?
  Custom_STAR_Params:
    type: string?
  Custom_bwa_mem2_Params:
    type: string?
expression: |-
  ${
    // the exclude intronic reads flag defaults to false
    var excludeIntronicReads = false;
    // the user can set the flag to exclude intronic reads
    if (inputs._Exclude_Intronic_Reads) {
      excludeIntronicReads = inputs._Exclude_Intronic_Reads;
    }

    // Use_Long_Reads default is autodetect, which happens in CheckFastqs
    // User can set this explicitly true or false
    // Convert boolean results to string.  null -> "auto", true -> "true", false -> "false"
    var longReads = "auto";
    if (inputs._Long_Reads !== null) {
      if (inputs._Long_Reads) {
        longReads = "true";
      }
      else {
        longReads = "false";
      }
    }

    return ({
      Exclude_Intronic_Reads: excludeIntronicReads,
      Long_Reads: longReads,
      Custom_STAR_Params: inputs._Custom_STAR_Params,
      Custom_bwa_mem2_Params: inputs._Custom_bwa_mem2_Params
    });


  }
