#!/usr/bin/env cwl-runner
cwlVersion: v1.2
class: CommandLineTool
baseCommand: echo
requirements:
  - class: InlineJavascriptRequirement
inputs:
  Run_Name: 
    type: string?
  Run_Base_Name:
    type: string
  Bead_Version:
    type:
      type: array
      items:
        type: record
        fields:
        - name: Library
          type: string
        - name: bead_version
          type: string
  Pipeline_Name:
    type: string
  Assay:
    type: string[]
  Pipeline_Version:
    type: string
  Cell_Calling_ATAC_Algorithm:
    type: Any?
  Cell_Calling_Bioproduct_Algorithm:
    type: Any?
  Cell_Calling_Data:
    type: int?
  Exact_Cell_Count:
    type: int?
  Expected_Cell_Count:
    type: int?
  Exclude_Intronic_Reads:
    type: boolean?
  Generate_Bam:
    type: boolean?
  VDJ_Version:
    type: string?
  AbSeq_Reference:
    type: File[]?
  Targeted_Reference:
    type: File[]?
  Reference_Archive:
    type: ["null", "File", "Directory"]
  Supplemental_Reference:
    type: File[]?
  Predefined_ATAC_Peaks:
    type: File?
  Sample_Tags_Version:
    type: string?
  Sample_Tag_Names:
    type: string[]?
  Start_Time:
    type: string?
  Libraries:
    type: string[]?
  Libraries_ATAC:
    type: string[]?
  Reads: 
    type: string[]?
  Reads_ATAC:
    type: string[]?
  Long_Reads:
    type: string
  Custom_STAR_Params:
    type: string?
  Custom_bwa_mem2_Params:
    type: string?
outputs:
  Run_Metadata:
    type: File
    outputBinding:
      glob: "run_metadata.json"
stdout: run_metadata.json
arguments:
  - prefix: ''
  - shellQuote: True
    valueFrom: |
      ${
        var metadata = inputs;
        var all_bv = {};
        var customer_bv = "Original (V1)";
        var detected_bv = "V1";
        for (var i = 0; i < inputs.Bead_Version.length; i++) {
            var BeadVer = inputs.Bead_Version[i];
            var Library = BeadVer["Library"];
            var bead_version = BeadVer["bead_version"];
            all_bv[Library] = bead_version;
            var short_bv =  bead_version.substring(0, 5);
            if (short_bv == "Enh") {
              customer_bv = "Enhanced";
              detected_bv = "Enh";
            }
            else if (short_bv == "EnhV2") {
              customer_bv = "Enhanced V2/V3";
              detected_bv = "EnhV2";
            }
        }
        metadata["Bead_Version"] = all_bv;
        metadata["Bead_Version_Detected"] = detected_bv;

        var pipeline_name = inputs.Pipeline_Name;
        var version = inputs.Pipeline_Version;
        var time = inputs.Start_Time;
        var libraries = inputs.Libraries;
        if(libraries == null){
            libraries = ["None"];
        }
        var libraries_atac = inputs.Libraries_ATAC;
        if(libraries_atac == null){
            libraries_atac = ["None"];
        }

        var i = 0;
        var refs_mrna_inputs = [];
        var mrna_name = "mRNA Reference";
        if (inputs.Targeted_Reference != null) {
            refs_mrna_inputs = refs_mrna_inputs.concat(inputs.Targeted_Reference);
            mrna_name = "Targeted Reference";
        }
        if(inputs.Reference_Archive != null){
            refs_mrna_inputs = refs_mrna_inputs.concat(inputs.Reference_Archive);
            mrna_name = "Reference Archive";
        }
        var refs_mrna = [];
        if (refs_mrna_inputs.length > 0) {
            for (i = 0; i < refs_mrna_inputs.length; i++) {
                if (refs_mrna_inputs[i] != null) {
                    refs_mrna.push(refs_mrna_inputs[i]["basename"]);
                }
            }
        }
        else {
            refs_mrna = ["None"];
        }

        var refs_abseq_inputs = [];
        if (inputs.AbSeq_Reference != null) {
            refs_abseq_inputs = refs_abseq_inputs.concat(inputs.AbSeq_Reference);
        }
        var refs_abseq = [];
        if (refs_abseq_inputs.length > 0) {
            for (i = 0; i < refs_abseq_inputs.length; i++) {
                if (refs_abseq_inputs[i] != null) {
                    refs_abseq.push(refs_abseq_inputs[i]["basename"]);
                }
            }
        }
        else {
            refs_abseq = ["None"];
        }

        var refs_supp_inputs = [];
        if (inputs.Supplemental_Reference != null) {
            refs_supp_inputs = refs_supp_inputs.concat(inputs.AbSeq_Reference);
        }
        var refs_supp = [];
        if (refs_supp_inputs.length > 0) {
            for (i = 0; i < refs_supp_inputs.length; i++) {
                if (refs_supp_inputs[i] != null) {
                    refs_supp.push(refs_supp_inputs[i]["basename"]);
                }
            }
        }
        else {
            refs_supp = ["None"];
        }

        if (inputs.Predefined_ATAC_Peaks != null) {
            var predef_atac_peaks = inputs.Predefined_ATAC_Peaks["basename"];
        } else {
            var predef_atac_peaks = "None";
        }

        var parameters = [];
        if(inputs.Sample_Tags_Version != null){
            var tags = "Sample Tag Version: " + inputs.Sample_Tags_Version;
        } else{ 
            var tags = "Sample Tag Version: None";
        }
        parameters.push(tags);

        if(inputs.Sample_Tag_Names != null){
            var tag_names = inputs.Sample_Tag_Names.join("; ");
            var tag_list = "Sample Tag Names: " + tag_names;
        } else{
            var tag_list = "Sample Tag Names: None";
        }
        parameters.push(tag_list);
       
        if(inputs.VDJ_Version != null){
            var vdj = "VDJ Version: " + inputs.VDJ_Version;
        } else{ 
            var vdj = "VDJ Version: None";
        }
        parameters.push(vdj);

        if (inputs.Cell_Calling_Data == 0) {
            var call = "Putative Cell Calling Data: mRNA";
        } else if (inputs.Cell_Calling_Data == 1) {
            var call = "Putative Cell Calling Data: AbSeq";
        } else if (inputs.Cell_Calling_Data == 2) {
            var call = "Putative Cell Calling Data: mRNA_and_AbSeq";
        } else if (inputs.Cell_Calling_Data == 3) {
            var call = "Putative Cell Calling Data: mRNA_and_ATAC";
        } else if (inputs.Cell_Calling_Data == 4) {
            var call = "Putative Cell Calling Data: AbSeq_and_ATAC";
        } else if (inputs.Cell_Calling_Data == 5) {
            var call = "Putative Cell Calling Data: ATAC";
        } else if (inputs.Cell_Calling_Data == 6) {
            var call = "Putative_Cell_Calling_Data: VDJ";
        } else {
            var call = "Putative Cell Calling Data: None";
        }
        parameters.push(call);

        if (inputs.Cell_Calling_Bioproduct_Algorithm != null) {
            var bioproduct_alg = "Bioproduct Cell Calling Algorithm: " + inputs.Cell_Calling_Bioproduct_Algorithm;
        } else {
            var bioproduct_alg = "Bioproduct Cell Calling Algorithm: None";
        }
        parameters.push(bioproduct_alg);

        if (inputs.Cell_Calling_ATAC_Algorithm != null) {
            var atac_alg = "ATAC Cell Calling Algorithm: " + inputs.Cell_Calling_ATAC_Algorithm;
        } else {
            var atac_alg = "ATAC Cell Calling Algorithm: None";
        }
        parameters.push(atac_alg);

        if(inputs.Exclude_Intronic_Reads){
            var introns = "Exclude Intronic Reads: On";
        } else{
            var introns = "Exclude Intronic Reads: Off";
        }
        parameters.push(introns);

        if(inputs.Generate_Bam){
            var generateBam = "Generate Bam: On";
        } else{
            var generateBam = "Generate Bam: Off";
        }
        parameters.push(generateBam);

        if(inputs.Exact_Cell_Count != null){
            var exactCells = "Exact Cell Count: " + inputs.Exact_Cell_Count;
        } else{
            var exactCells = "Exact Cell Count: None";
        }
        parameters.push(exactCells);

        if(inputs.Expected_Cell_Count != null){
            var expectedCells = "Expected Cell Count: " + inputs.Expected_Cell_Count;
        } else{
            var expectedCells = "Expected Cell Count: None";
        }
        parameters.push(expectedCells);

        var longReads = "Long Reads: " + inputs.Long_Reads;
        parameters.push(longReads);

        if (inputs.Custom_STAR_Params != null)
        {
          var starParams = "Custom STAR Params: " + inputs.Custom_STAR_Params;
        } else {
          var starParams = "Custom STAR Params: None"; 
        }
        parameters.push(starParams);

        if (inputs.Custom_bwa_mem2_Params != null)
        {
          var bwaParams = "Custom bwa-mem2 Params: " + inputs.Custom_bwa_mem2_Params;
        } else {
          var bwaParams = "Custom bwa-mem2 Params: None";
        }
        parameters.push(bwaParams);
  
        var run_name = inputs.Run_Name;
        var run_base_name = inputs.Run_Base_Name;

        var header = ["####################"];
        header.push("## " + pipeline_name + " Version " + version);
        header.push("## Analysis Date - " + time);
        header.push("## Libraries - Bioproduct Libraries: " + libraries.join('; ') + " | ATAC Libraries: " + libraries_atac.join('; ') + " | Bead version detected: " + customer_bv);
        header.push("## References - " + mrna_name + ": " + refs_mrna.join('; ') + " | AbSeq Reference: " + refs_abseq.join('; ') + " | Supplemental Reference: " + refs_supp.join('; ') + " | ATAC Predefined Peak Regions: " + predef_atac_peaks);
        header.push("## Parameters - " + parameters.join(' | '));
        header.push("####################");
        metadata["Output_Header"] = header;
        metadata["Run_Name"] = run_name;   
        metadata["Run_Base_Name"] = run_base_name;

        var metadata_json = JSON.stringify(metadata, null, 2);

        return metadata_json;
      }
