cwlVersion: v1.2
requirements:
  InlineJavascriptRequirement: {}
  ShellCommandRequirement: {}
  InitialWorkDirRequirement:
    listing:
      - entryname: bam_files.txt
        entry: |-
          ${
              function getBamsInSortedOrder(inputs) {
                  // Create an associative array to hold the mapping from basename to full path
                  var fileMap = {};

                  // Extract basenames and map them to their full paths
                  for (var i = 0; i < inputs.BamFiles.length; i++) {
                      var file = inputs.BamFiles[i].path;
                      var basename = file.split('/').pop();
                      fileMap[basename] = file;
                  }

                  // Sort the basenames numerically
                  // This works because all bams share the same prefix and have a numerical id :
                  // i.e. foobar.0001.tagged.bam, foobar.0002.tagged.bam, foobar.0010.tagged.bam, etc.
                  //  so will be sorted by numerical ids
                  var sortedBasenames = Object.keys(fileMap).sort(function(a, b) {
                      return a.localeCompare(b, undefined, { numeric: true });
                  });

                  // Reconstruct the sorted full paths
                  var sortedBamFiles = sortedBasenames.map(function(basename) {
                      return fileMap[basename];
                  });

                  // Create a file of file names - 1 per line
                  return sortedBamFiles.join('\n');
              }

              // For ATAC we cat the bams so need them in a particular order
              if (inputs.Assay == "ATAC") {
                  return getBamsInSortedOrder(inputs);
              }
              else {
                  return inputs.BamFiles.map(function(file) {
                      return file.path;
                  }).join('\n');
              }
          }
        writable: false

hints:
  - class: 'DockerRequirement'
    dockerPull: mist:dev_20251028_183627_5d0e14dd
  - class: 'ResourceRequirement'
    coresMin: 8
    ramMin: 16000

class: CommandLineTool
baseCommand:
- MergeBam.sh
stderr: merge_bam.log
inputs:
  Run_Metadata:
    type: File
    loadContents: true
  BamFiles:
    type: File[]?
  Generate_Bam:
    type: boolean?
  Assay:
    type: string
    inputBinding:
      position: 1
arguments:
  - position: 2
    valueFrom: |-
      ${
          var st_version = JSON.parse(inputs.Run_Metadata.contents).Sample_Tags_Version
          if (st_version)
          {
            return st_version
          } else
          {
            return "None"
          }
      }
  - position: 3
    valueFrom: $(JSON.parse(inputs.Run_Metadata.contents).Run_Base_Name)
  - position: 4
    valueFrom: $(runtime.cores)
  - position: 5
    valueFrom: bam_files.txt

outputs:
  Bam:
    type: File
    outputBinding:
      glob: ${ return "*" + JSON.parse(inputs.Run_Metadata.contents).Run_Base_Name + "*.bam" }
  BamIndex:
    type: File
    outputBinding:
      glob: ${ return "*" + JSON.parse(inputs.Run_Metadata.contents).Run_Base_Name + "*.bam.*" }
  log:
    type: File
    outputBinding:
      glob: '*.log'
