requirements:
  - class: ResourceRequirement
    ramMin: 48000
  - class: InlineJavascriptRequirement
hints:
  - class: DockerRequirement
    dockerPull: mist:dev_20251028_183627_5d0e14dd
cwlVersion: v1.2
class: CommandLineTool
baseCommand:
- mist_get_datatables.py
inputs:
  Cell_Biop_Summary_List:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --cell-biop-summary-list
  Bioproduct_Stats_List:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --bioproduct-stats-list
  Total_Molecules:
    type: int[]?
  Seq_Metrics:
    type: File?
    inputBinding:
      prefix: --seq-metrics
  ATAC_Cell_Calling_Input:
    type: File?
    inputBinding:
      prefix: --atac-cell-calling-data-file
  Full_Genes:
    type: File?
    inputBinding:
      prefix: --full-gene-list
  Run_Metadata:
    type: File
    inputBinding:
      prefix: --run-metadata
  Gene_Name_ID_Json:
    type: File
    inputBinding:
      prefix: --feature-name-json
  num_cell_estimate:
    type: int?
  num_bioproducts:
    type: int?
outputs:
  Metrics_tar:
    type: File
    outputBinding:
      glob: metrics-files.tar.gz
  Bioproduct_Stats:
    type: File?
    outputBinding:
      glob: "*_Bioproduct_Stats.csv"
  Cell_Order:
    type: File?
    outputBinding:
      glob: "cell_order.json"
  Cell_Order_Subsampled:
    type: File?
    outputBinding:
      glob: "cell_order_subsampled.json"
  Cell_Type_Predictions:
    type: File?
    outputBinding:
      glob: "*cell_type_experimental.csv"
  Data_Tables:
    type: File[]?
    outputBinding:
      glob: '*_MEX.zip'
  Biop_putative_data_table:
    type: File?
    outputBinding:
      glob: "*_RSEC_MolsPerCell_MEX.zip"
  Dim_Reduction_Coord:
    type: File[]?
    outputBinding:
      glob: "*_coordinates.csv"
  output:
    type: File
    outputBinding:
      glob: '*.log'
  Protein_Aggregates_Experimental:
    type: File?
    outputBinding:
      glob: "Protein_Agg/*_Protein_Aggregates_Experimental.csv"
  Putative_Cells_Origin:
    type: File?
    outputBinding:
      glob: "Cell_Label_Filtering/*_Putative_Cells_Origin.csv"
  SampleTag_Calls:
    type: File?
    outputBinding:
      glob: "SampleTag/*_Sample_Tag_Calls.csv"
  SampleTag_CSVs:
    type: File[]?
    outputBinding:
      glob: SampleTag/*csv
  SampleTag_perTagZips:
    type: File[]?
    outputBinding:
      glob: SampleTagArchives/*zip
