cwlVersion: v1.2

class: CommandLineTool

requirements:
  - class: InlineJavascriptRequirement
  - class: StepInputExpressionRequirement

hints:
- class: DockerRequirement
  dockerPull: mist:dev_20251028_183627_5d0e14dd
- class: ResourceRequirement
  ramMin: 32000

baseCommand: GenerateSeurat.R

inputs:
  Data_Tables:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --data-tables
  Bioproduct_Stats:
    type: File?
    inputBinding:
      prefix: --bioproduct-stats
  Cell_Type_Experimental:
    type: File[]?
    inputBinding:
      prefix: --cell-type-experimental
      itemSeparator: ','
  Putative_Cells_Origin:
    type: File?
    inputBinding:
      prefix: --putative-cells-origin
  SampleTag_Calls:
    type: File?
    inputBinding:
      prefix: --sample-tag-calls
  SampleTag_CSVs:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --sample-tag-csvs
  Dim_Reduction_Coord:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --coordinates-file-list
  Protein_Aggregates_Experimental:
    type: File?
    inputBinding:
      prefix: --protein-aggregates-experimental
  VDJ_Per_Cell:
    type: File?
    inputBinding:
      prefix: --vdj-per-cell
  Run_Metadata:
    type: File
    loadContents: true
  ATAC_Seurat:
    type: File?
    inputBinding:
      prefix: --atac-seurat-rds
  Atac_Motif_Datatables:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --atac-motif-data-table
  Atac_Peak_Seq:
    type: File?
    inputBinding:
      prefix: --atac-peak-seq
  Atac_Background_Peaks:
    type: File?
    inputBinding:
      prefix: --atac-background-peaks
  Transcription_Factor_Motif_PFM:
    type: File?
    inputBinding:
      prefix: --pfm-file
  Atac_Motif_Positions:
    type: File?
    inputBinding:
      prefix: --atac-motif-positions
arguments:
- prefix: --base-name
  valueFrom: $(JSON.parse(inputs.Run_Metadata.contents).Run_Base_Name)

outputs:
  SeuratRDS:
    type: File?
    outputBinding:
      glob: '*.rds'
  output:
    type: File?
    outputBinding:
      glob: '*.log'
