requirements:
  InlineJavascriptRequirement: {}
  InitialWorkDirRequirement:
    listing:
      # Required when Reference_Archive is passed in as a directory.
      - $(inputs.Reference_Archive)
hints:
  - class: 'DockerRequirement'
    dockerPull: mist:dev_20251028_183627_5d0e14dd
cwlVersion: v1.2
class: CommandLineTool
baseCommand:
- mist_check_references.py
inputs:
  Targeted_Reference:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --targeted-reference
  Reference_Archive:
    type: ["null", "File", "Directory"]
    inputBinding:
      prefix: --reference-archive
  Supplemental_Reference:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --supplemental-reference
  AbSeq_Reference:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --abseq-reference
  Cell_Calling_Data:
    type: int?
    inputBinding:
      prefix: --putative-cell-call
  Assay:
    type: string[]
    inputBinding:
      itemSeparator: ','
      prefix: --assay
  VDJ_Version:
    type: string?

    inputBinding:
      prefix: --vdj-version
  Sample_Tags_Version:
    type: string?
    inputBinding:
      prefix: --sample-tags-version
  Predefined_ATAC_Peaks:
    type: File?
    inputBinding:
      prefix: "--predefined-peaks"
outputs:
  Index:
    type: Directory
    outputBinding:
      glob: 'BD_Rhapsody_Reference_Files'
  Extra_Seqs:
    type: File?
    outputBinding:
      glob: 'combined_extra_seq.fasta'
  output:
    type: File
    outputBinding:
      glob: '*.log'
  Full_Genes:
    type: File?
    outputBinding:
      glob: full-gene-list.json
  Transcript_Length:
    type: File?
    outputBinding:
      glob: transcript_length.json
  GTF:
    type: File
    outputBinding:
      glob: 'BD_Rhapsody_Reference_Files/*.gtf'
  Reference_FASTA:
    type: File?
    outputBinding:
      glob: 'BD_Rhapsody_Reference_Files/*.fasta.gz'
    secondaryFiles:
    - .fai
    - .gzi
  Target_Gene_Mapping:
    type: File?
    outputBinding:
      glob: target-gene.json
  Transcription_Factor_Motif_PFM:
    type: File?
    outputBinding:
      glob: 'BD_Rhapsody_Reference_Files/*.pfm'
  Checked_Predefined_Peaks:
    outputBinding:
      glob: '*_ATAC_Peaks.bed.gz'
    type: File?
    secondaryFiles:
      - .tbi
  Checked_Predefined_Peaks_Index:
    outputBinding:
      glob: '*_ATAC_Peaks.bed.gz.tbi'
    type: File?

