cwlVersion: v1.2

class: CommandLineTool

requirements:
  InlineJavascriptRequirement: {}
  ShellCommandRequirement: {}

doc: >
  This step computes sequencing saturation at various downsampled mean useful reads per cell values and outputs
  the necessary information to construct a sequencing saturation curve

hints:
- class: DockerRequirement
  dockerPull: mist:dev_20251028_183627_5d0e14dd

- class: ResourceRequirement
  ramMin: |
    ${
      const BASE_MEM_FOR_NODE = 2 * 1024 * 1024 * 1024; // Base : 2G memory
      const BYTES_PER_ENTRY = 128;
      const totalLines = inputs.Num_Mols_Corrected || 0; // Then scale based on the # rsec corrected mols - used to contruct a look-up table
      const requiredBytes = totalLines * BYTES_PER_ENTRY + BASE_MEM_FOR_NODE;
      return Math.ceil(requiredBytes / (1024 * 1024));
    }
  coresMin: |
    ${
      const n = 8;
      if (inputs.Threads) {
        return Math.min(inputs.Threads, n);
      } else {
        return n;
      }
    }

baseCommand:
- mist_calc_seq_saturation.py

inputs:
  Corrected_Mols:
    type: File[]
    inputBinding:
      prefix: "--corrected-mols-list"
      itemSeparator: ","
  Metrics_Tar:
    type: File
    inputBinding:
      prefix: "--metrics-tar"
  Putative_Cells:
    type: File
    inputBinding:
      prefix: "--putative-cells-json-fp"
  Run_Base_Name:
    type: string
    inputBinding:
      prefix: "--run-name"
  Valid_Reads_CSV:
    type: File[]
    inputBinding:
      prefix: "--valid-reads-csv-list"
      itemSeparator: ","
  Threads:
    type: int?
    inputBinding:
      prefix: "--threads"
  Targeted_Reference_Present:
    type: boolean
  Reference_Archive_Present:
    type: boolean
  AbSeq_Reference_Present:
    type: boolean
  Num_Mols_Corrected:
    type: int
outputs:
    Seq_Saturation_Plot_Json:
      type: File
      outputBinding:
        glob: "*_seq_saturation_plot.json"