cwlVersion: v1.2
class: ExpressionTool
requirements:
- class: InlineJavascriptRequirement
- class: MultipleInputFeatureRequirement
inputs:
  log_files: File[]
outputs:
  logs_dir: Directory
expression: |-
  ${
    /* shamelly cribbed from https://gist.github.com/jcxplorer/823878 */
    function uuid() {
      var uuid = "", i, random;
      for (i = 0; i < 32; i++) {
        random = Math.random() * 16 | 0;
        if (i == 8 || i == 12 || i == 16 || i == 20) {
          uuid += "-";
        }
        uuid += (i == 12 ? 4 : (i == 16 ? (random & 3 | 8) : random)).toString(16);
      }
      return uuid;
    }
    var listing = [];
    for (var i = 0; i < inputs.log_files.length; i++) {
      var log_file = inputs.log_files[i];
      /*
        Checking here for null in case a Node was skipped because of conditional execution.
        For e.g. Generate_Bam is used to skip the AddToBam, MergeBam and IndexBam nodes
      */
      if (log_file != null) {
        log_file.basename = uuid() + "-" + log_file.basename;
        listing.push(log_file);
      }
    }
    return ({
      logs_dir: {
        class: "Directory",
        basename: "Logs",
        listing: listing
      }
    });
  }
