cwlVersion: v1.2
class: ExpressionTool
requirements:
- class: InlineJavascriptRequirement
inputs:
  Targeted_Reference_Present:
    type: boolean
  Reference_Archive_Present:
    type: boolean
  AbSeq_Reference_Present:
    type: boolean
  Reads_ATAC_Present:
    type: boolean
  Reads_RNA_Present:
    type: boolean
  Cell_Calling_Data:
    type: int
outputs:
  Assay_RNA:
    type: string?
  Assay_ATAC:
    type: string?
expression: |-
  ${
    var assay_rna = null;
    var assay_atac = null;

    if (!inputs.Reads_ATAC_Present && !inputs.Reads_RNA_Present)
    {
      throw new Error('Invalid pipeline inputs: Please provide Reads for at least 1 of RNA or ATAC analysis.')
    }
    if (inputs.Targeted_Reference_Present && inputs.Reference_Archive_Present) {
      throw new Error('Invalid pipeline inputs: Do not provide both Targeted Reference and Reference Archive.')
    }
    if (!inputs.Targeted_Reference_Present && !inputs.AbSeq_Reference_Present && !inputs.Reference_Archive_Present && inputs.Cell_Calling_Data != 6) {
      throw new Error('Invalid pipeline inputs: Please provide either a Reference Archive or a Targeted Reference or an AbSeq Reference. If you are analyzing VDJ data only, then please choose VDJ only cell calling algorithm.')
    }

    if ( inputs.Reads_ATAC_Present )
    {
      assay_atac = 'ATAC'
    }

    if (inputs.Reads_RNA_Present && inputs.Reference_Archive_Present && inputs.Cell_Calling_Data != 6) {
      assay_rna = 'WTA'
    }
    else if (inputs.Reads_RNA_Present && (inputs.Targeted_Reference_Present || inputs.AbSeq_Reference_Present || inputs.Cell_Calling_Data == 6)) {
      assay_rna = 'Targeted'
    }


    return ({Assay_RNA: assay_rna, Assay_ATAC: assay_atac})
  }
