requirements:
  InlineJavascriptRequirement: {}
  ShellCommandRequirement: {}
doc: >
  AlignmentAnalysis stage of the Rain pipeline annotates aligned reads and collects
  a myriad of metrics on the aligned reads. Additional annotation is
  performed to the reads
cwlVersion: v1.2
hints:
- class: 'DockerRequirement'
  dockerPull: mist:dev_20251028_183627_5d0e14dd
- class: ResourceRequirement
  coresMin: 8
  ramMin: 24000
class: CommandLineTool
baseCommand:
- AlignmentAnalysisAndCountCB.sh
inputs:
  Transcript_Length:
    inputBinding:
      prefix: "--transcript-length"
    type: File?
  Maximum_Threads:
    inputBinding:
      prefix: "--threads"
    type: int?
  Run_Metadata:
    inputBinding:
      prefix: "--run-metadata"
    type: File
  Assay:
    inputBinding:
      prefix: "--assay"
    type: string?
  GTF:
    inputBinding:
      prefix: "--gtf"
    type: File?
  Extra_Seqs:
    inputBinding:
      prefix: "--extra-seqs"
    type: File?
  R2_BAM:
    inputBinding:
      prefix: "--r2-bam"
      itemSeparator: ","
    type: File[]?
  ReadQualityMetrics:
    inputBinding:
      prefix: "--quality-metrics"
    type: File?
  Exclude_Intronic_Reads:
    inputBinding:
      prefix: "--exclude-intronic-reads"
    type: boolean?
outputs:
  Annotated_Bam_Files:
    type: File[]
    outputBinding:
      glob: "*.annotated.*.bam"
  Gene_Name_ID_Json:
    type: File
    outputBinding:
      glob: "*gtf.gene_info.json"
  Seq_Metrics:
    type: File
    outputBinding:
      glob: "*_SeqMetrics.csv"
  Sorted_Valid_Reads_CSV:
    type: File[]
    outputBinding:
      glob: "*Sorted_Valid_Reads.csv.*"
  Logs:
    outputBinding:
      glob: "*logs.tar.gz"
    type: File?
  validTcrReads:
    type: File?
    outputBinding:
      glob: "*_VDJ_TCR_Valid_Reads.fastq.gz"
  validIgReads:
    type: File?
    outputBinding:
      glob: "*_VDJ_BCR_Valid_Reads.fastq.gz"
  num_valid_tcr_reads:
    type: long
    outputBinding:
      glob: num_vdj_reads.json
      loadContents: true
      outputEval:
        ${
          if (!self[0]) {
            return 0;
          }
          return parseInt(JSON.parse(self[0].contents).TCR);
        }
  num_valid_ig_reads:
    type: long
    outputBinding:
      glob: num_vdj_reads.json
      loadContents: true
      outputEval:
        ${
          if (!self[0]) {
            return 0;
          }
          return parseInt(JSON.parse(self[0].contents).BCR);
        }
  num_cell_estimate:
    type: int
    outputBinding:
      glob: count_estimates.json
      loadContents: true
      outputEval:
        ${
          if (!self[0]) {
            return 10000;
          }
          return parseInt(JSON.parse(self[0].contents).num_cell_estimate);
        }
  num_bioproducts:
    type: int
    outputBinding:
      glob: count_estimates.json
      loadContents: true
      outputEval:
        ${
          if (!self[0]) {
            return 30000;
          }
          return parseInt(JSON.parse(self[0].contents).num_bioproducts);
        }
