cwlVersion: v1.2
class: CommandLineTool

requirements:
  InlineJavascriptRequirement: {}

hints:
  - class: 'DockerRequirement'
    dockerPull: mist:dev_20251028_183627_5d0e14dd
  - class: 'ResourceRequirement'
    coresMin:
        ${
          if (inputs.Assay == 'ATAC') {
            return 2;
          } else {
            return 4;
          }
        }
    ramMin:
        ${
          if (inputs.Assay == 'ATAC') {
            return 4000;
          } else {
            return 32000;
          }
        }

baseCommand:
- mist_add_to_bam.py

inputs:
  Assay:
    type: string
    inputBinding:
      prefix: "--assay"
  Cell_Order:
    type: File
    inputBinding:
      prefix: "--cell-order-json"
  Corrected_Mols:
    type: File[]?
    inputBinding:
      prefix: "--corrected-mols-list"
      itemSeparator: ','
  SampleTag_Calls:
    type: File?
    inputBinding:
      prefix: "--sample-tag-calls"
  Bam:
    type: File
    inputBinding:
      prefix: "--input-bam"
  Run_Metadata:
    type: File
    inputBinding:
      prefix: "--run-metadata-json"
  Target_Gene_Mapping:
    type: File?
    inputBinding:
      prefix: "--target-gene-mapping"
  Generate_Bam:
    type: boolean?

arguments:
  - prefix: "--bamIO-threads"
    valueFrom: $(runtime.cores)

outputs:
  Annotated_Bam:
    type: File
    outputBinding:
      glob: "*.bam"
  output:
    type: File
    outputBinding:
      glob: "*.log"
