cwlVersion: v1.2

class: CommandLineTool

hints:
- class: DockerRequirement
  dockerPull: mist:dev_20251028_183627_5d0e14dd
- class: ResourceRequirement
  ramMin: 48000

baseCommand:
- mist_atac_motif_analysis.py

inputs:
  Atac_Datatables:
    type: File[]?
    inputBinding:
      itemSeparator: ','
      prefix: --atac-cell-by-peak
  Reference_FASTA:
    type: File?
    inputBinding:
      prefix: --reference-fasta
    secondaryFiles:
      - .fai
      - .gzi      
  Transcription_Factor_Motif_PFM:
    type: File?
    inputBinding:
      prefix: --pfm-file
  Maximum_Threads:
    type: int?
    inputBinding:
      prefix: --threads
  Run_Metadata:
    type: File
    inputBinding:
      prefix: --run-metadata
outputs:
  ATAC_Motif_Data_Tables:
    type: File[]?
    outputBinding:
      glob: '*_MEX.zip'
  ATAC_Peak_Seq:
    type: File?
    outputBinding:
      glob: "ATAC-Peak-Seq.csv.gz"
  ATAC_Background_Peaks:
    type: File?
    outputBinding:
      glob: "ATAC-Background-Peaks.csv.gz"
  ATAC_Motif_Positions:
    type: File?
    outputBinding:
      glob: "*_ATAC_Motif_Positions.tsv.gz"
  output:
    type: File
    outputBinding:
      glob: '*.log'
