cwlVersion: v1.2

class: CommandLineTool

requirements:
  InlineJavascriptRequirement: {}
  StepInputExpressionRequirement: {}

hints:
- class: DockerRequirement
  dockerPull: mist:dev_20251028_183627_5d0e14dd
- class: ResourceRequirement
  ramMin: 48000

baseCommand: ATAC_Compile_Results.R

inputs:
  Initial_Seurat_RDS:
    type: File?
    inputBinding:
      prefix: --initial-seurat
  Cell_Order:
    type: File?
    inputBinding:
      prefix: --cell-order
  Cell_Order_Subsampled:
    type: File?
    inputBinding:
      prefix: --cell-order-subsampled
  Unified_Metrics:
    type: File?
    inputBinding:
      prefix: --unified-metrics
  Total_Fragment_Metrics:
    type: File?
    inputBinding:
      prefix: --total-fragment-metrics
  Fragments:
    type: File?
    inputBinding:
      prefix: --fragments
    secondaryFiles: .tbi
  Run_Metadata:
    type: File
    inputBinding:
      prefix: --run-metadata
  Gene_Name_ID_Json:
    type: File
    inputBinding:
      prefix: --feature-name-json
  Input_Metrics_tar:
    type: File
    inputBinding:
      prefix: --input-metrics-tar
  Biop_putative_data_table:
    type: File?
    inputBinding:
      prefix: --biop-putative-data-table
  Reference_Genome_Size:
    type: string
    inputBinding:
      prefix: --genome-size
  Reference_Genome_Contig_Lengths:
    type: File?
    inputBinding:
      prefix: --genome-contig-lengths
outputs:
  Metrics_tar:
    type: File
    outputBinding:
      glob: metrics-files.tar.gz
  ATAC_Data_Tables:
    type: File[]?
    outputBinding:
      glob: '*_MEX.zip'
  ATAC_Dim_Reduction_Coord:
    type: File[]?
    outputBinding:
      glob: '*/*_coordinates.csv'
  ATAC_Seurat_RDS:
    type: File?
    outputBinding:
      glob: '*_ATAC_Seurat.rds'
  Cell_Type_Predictions:
    type: File?
    outputBinding:
      glob: '*cell_type_experimental.csv'
  output:
    type: File
    outputBinding:
      glob: 'mist_atac_compile_results.log'