cwlVersion: v1.2

class: CommandLineTool

requirements:
  - class: InlineJavascriptRequirement
  - class: StepInputExpressionRequirement

hints:
- class: DockerRequirement
  dockerPull: mist:dev_20251028_183627_5d0e14dd
- class: ResourceRequirement
  ramMin: 64000

baseCommand: ATAC_Cell_by_Peak.R

inputs:
  Fragments:
    type: File?
    inputBinding:
      prefix: --fragments
    secondaryFiles: .tbi
  Transposase_Sites:
    type: File?
    inputBinding:
      prefix: --transposase-sites
    secondaryFiles: .tbi
  Peaks:
    type: File?
    inputBinding:
      prefix: --peaks
    secondaryFiles: .tbi
  Run_Metadata:
    type: File
    loadContents: true
  GTF:
    type: File
    inputBinding:
      prefix: --gtf
  Map_Gene_Name_ID:
    type: boolean
    inputBinding:
      prefix: --map-gene-name-id
arguments:
- prefix: --base-name
  valueFrom: $(JSON.parse(inputs.Run_Metadata.contents).Run_Base_Name)

outputs:
  Initial_Seurat_RDS:
    type: File?
    outputBinding:
      glob: '*_Initial_Seurat.rds'
  Total_Fragment_Metrics:
    type: File?
    outputBinding:
      glob: '*_Total_Fragment_Metrics.json'
  ATAC_Cell_Calling_Data:
    type: File?
    outputBinding:
      glob: '*_ATAC_Cell_Calling_Data.csv'
  Gene_Name_ID_Json:
    type: File?
    outputBinding:
      glob: "*atac.gene_info.json"
  output:
    type: File?
    outputBinding:
      glob: '*.log'
